<?php
/* --------------------------------------------------------------
 PermissionServiceProvider.php 2020-04-16
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2020 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

declare(strict_types=1);

namespace Gambio\Core\Permission;

use Doctrine\DBAL\Connection;
use Gambio\Core\Application\ServiceProviders\Abstraction\AbstractServiceProvider;
use Gambio\Core\Permission\Repositories\PermissionsReader;

/**
 * Class PermissionServiceProvider
 *
 * @package Gambio\Core\Permission
 */
class PermissionServiceProvider extends AbstractServiceProvider
{
    /**
     * @inheritDoc
     */
    public function provides(): array
    {
        return [
            PermissionRepository::class,
        ];
    }
    
    
    /**
     * @inheritDoc
     */
    public function register(): void
    {
        $this->application->add(PermissionsReader::class)->addArgument(Connection::class);
        
        $this->application->share(PermissionRepository::class, Repositories\PermissionsRepository::class)
            ->addArgument(PermissionsReader::class);
    }
}